function [ sqA labels ] = getSquareMatrix( obj )
%GETSQUAREMATRIX returns a square matrix representing this AdjacencyMatrix
%object, with the row labels and column labels in the same order
%   [A LABELS] = GETSQUAREMATRIX( OBJ ) returns a NxN sparse matrix A,
%   where N is the number of cells in the AdjacencyMatrix obj, and labels
%   is a Nx1 cell array of strings, representing the labels of the rows and
%   columns of A

labels = {obj.cells.name}';

% Pre allocate sqA
sqA = sparse(numel(labels),numel(labels));

[ii jj] = find(obj.A);

% Loop through non-zero entries of obj.A
for k = 1:numel(ii)
    sqA(obj.rowIndices(ii(k)),obj.columnIndices(jj(k))) = obj.A(ii(k),jj(k));
end


end

